'''
Diese Datei zeigt den mithilfe des Chatbots programmierten Code zur Analyse von csv-Dateien
'''

# Importieren der noetigen Bibliothek
import csv

def contains_only_letters(string) -> bool:
    '''
    Diese Funktion ueberprueft, ob der uebergebene String nur aus Buchstaben besteht
    und liefert einen boolean zurueck
    '''
    return string.isalpha()

def find_state_with_highest_population() -> str:
    '''
    In dieser Funktion wird das Bundesland mit der hoechsten Einwohnendenzahl ermittelt und
    dieses als String zurueck gegeben.
    '''
    with open('bevoelkerung_deutschland.csv', 'r') as file:
        reader = csv.reader(file, delimiter=',')
        next(reader)  # Skip the header row

        max_population = 0
        state_with_max_population = ''

        for row in reader:
            state = row[0]
            population = row[1]

            if state == 'Deutschland':
                continue

            if not contains_only_letters(population ):
                population = population.replace(' ','')
                population = population.replace(',','.')
                population = float(population)
                if population > max_population:
                    max_population = population
                    state_with_max_population = state

        return state_with_max_population

# Ermitteln und Ausgeben des Bundeslands mit der hoechsten Einwohnendenzahl
state = find_state_with_highest_population()
print(f"The state in Germany with the highest population is: {state}.")